/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.system;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.service.config.DirParseUtils;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystemManager;
import com.ibm.hwmca.fw.service.managedsystem.config.ManagedSystemConfigData;
import com.ibm.hwmca.fw.service.managedsystem.config.ManagedSystemConfigParser;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.repair.utils.XRVLog;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class InitServices
implements Runnable {
    private static final String TRACE_MASKT = "XS-INITT";
    private static final String TRACE_MASKF = "XS-INITF";
    private static final String TRACE_MASKD = "XS-INITD";

    public void run() {
        try {
            String baseFilePath = BaseFileControl.getFilePath("sysconfig");
            Trace.trace(TRACE_MASKD, "Looking in '" + baseFilePath + "' for system/service config files.");
            ServiceInterfaces.addAllFiles(baseFilePath);
        }
        catch (HException he) {
            Trace.trace(TRACE_MASKF, "InitServices: HException caught initing ServiceInterfaces xml file(s)[" + he + "]");
        }
        try {
            Trace.trace(TRACE_MASKF, "InitServices: configuring ManagedSystems");
            List configData = DirParseUtils.parseDir(new ManagedSystemConfigParser(), new File(BaseFileControl.getFilePath("managedsystemconfig")));
            if (configData != null) {
                Iterator it = configData.iterator();
                while (it.hasNext()) {
                    ManagedSystemManager.setConfigData((ManagedSystemConfigData)it.next());
                }
                ManagedSystemManager m = ManagedSystemManager.getManager();
                Trace.trace(TRACE_MASKF, "InitServices: ManagedSystemManager init worked!!!");
            } else {
                Trace.trace(TRACE_MASKF, "InitServices: no ManagedSystemManager config data defined");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
            if (e instanceof HException) {
                XRVLog.logit((short)1, e);
            }
            XRVLog.logit((short)2, e);
        }
    }
}

